// *Written by:* 		  Andr Anundsen
// *Purpose:*    		  Run ADF-test on the levels of the series 
// *Date of last update:* 11/12-2013
levels()
{
model = new PcGive();
model.Load(root | "Appendix/OxCodes for individual unit root tests/Data/Data.csv");      
model.Deterministic(3);

decl i, j, l; 
// To collect t-values for different lags, decide on the optimal lag truncation and collect the t-adf statistic
tval_level          = zeros(N,variables);
lags_level          = zeros(N,variables);

for(l = 0; l <= variables-1; l ++)
{
t_level             = zeros(N,max_lag + 1);

for (i = firsters; i <= lasters;  i ++)											 			   
{
if(Ddata[l][118][i] == .NaN)
{
tval_level[i][l] = .NaN;
}
else
{
println("This is test of levels for area ", i); 
model.DeSelect();
model.Renew(Ddata[l][0:][i],"Dvar");
model.Select(Y_VAR, {"Dvar", 0, max_lag});
model.Renew(data[l][0:][i],"var"); 
model.Select(X_VAR, {"var", 1, 1});
model.Select(X_VAR, {"Constant", 0, 0});
//model.Select(X_VAR, {"Trend", 0, 0});															   
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter, end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
decl extra          = total_obs - model.GetcT();
decl end = (total_obs - 1 - model.GetSelEnd());
model.DeSelect(); 

model.Renew(Ddata[l][0:][i],"Dvar"); 
model.Select(Y_VAR, {"Dvar", 0, 0});
model.Renew(data[l][0:][i],"var"); 
model.Select(X_VAR, {"var", 1, 1});

model.Select(X_VAR, {"Constant", 0, 0});
//model.Select(X_VAR, {"Trend", 0, 0});
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
decl tval  = fabs(model.GetFreePar() ./ model.GetStdErr()); 
if(seasons)
{
t_level[i][0] = tval[model.GetFreeParCount() - 4 - 1][]; 
}
else
{
t_level[i][0] = tval[model.GetFreeParCount() - 1 - 1][]; 
}

// Number of lags in the models. Increase by one for each stage of j loop
for(j = 1; j <= max_lag; j ++)
{
model.Select(X_VAR, {"Dvar", j, j});
model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
tval  = fabs(model.GetFreePar() ./ model.GetStdErr()); 
if(seasons)
{
t_level[i][j] = tval[model.GetFreeParCount() - 5 - 1][]; 
}
else
{
t_level[i][j] = tval[model.GetFreeParCount() - 2 - 1][]; 
}
}

// Choosing the optimal lag truncation of the endogenous variables

if(max_lag == 8)
{
if(t_level[i][8] >= t_crit_val)
{
lags_level[i][l] = 8; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] >= t_crit_val)
{
lags_level[i][l] = 7; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] >= t_crit_val)
{
lags_level[i][l] = 6; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] >= t_crit_val)
{
lags_level[i][l] = 5; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] >= t_crit_val)
{
lags_level[i][l] = 4; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][8] < t_crit_val && t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}

if(max_lag == 7)
{
if(t_level[i][7] >= t_crit_val)
{
lags_level[i][l] = 7; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] >= t_crit_val)
{
lags_level[i][l] = 6; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] >= t_crit_val)
{
lags_level[i][l] = 5; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] >= t_crit_val)
{
lags_level[i][l] = 4; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][7] < t_crit_val && t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}


if(max_lag == 6)
{
if(t_level[i][6] >= t_crit_val)
{
lags_level[i][l] = 6; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] >= t_crit_val)
{
lags_level[i][l] = 5; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] >= t_crit_val)
{
lags_level[i][l] = 4; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][6] < t_crit_val && t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}

if(max_lag == 5)
{
if(t_level[i][5] >= t_crit_val)
{
lags_level[i][l] = 5; 
}
if(t_level[i][5] < t_crit_val && t_level[i][4] >= t_crit_val)
{
lags_level[i][l] = 4; 
}
if(t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][5] < t_crit_val && t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}


if(max_lag == 4)
{
if(t_level[i][4] >= t_crit_val)
{
lags_level[i][l] = 4; 
}
if(t_level[i][4] < t_crit_val && t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][4] < t_crit_val && t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}


if(max_lag == 3)
{
if(t_level[i][3] >= t_crit_val)
{
lags_level[i][l] = 3; 
}
if(t_level[i][3] < t_crit_val && t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][3] < t_crit_val && t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}


if(max_lag == 2)
{
if(t_level[i][2] >= t_crit_val)
{
lags_level[i][l] = 2; 
}
if(t_level[i][2] < t_crit_val && t_level[i][1] >= t_crit_val)
{
lags_level[i][l] = 1; 
}
if(t_level[i][2] < t_crit_val && t_level[i][1] < t_crit_val)
{
lags_level[i][l] = 0; 
}
}
model.DeSelect();

model.Renew(Ddata[l][0:][i],"Dvar"); 
model.Select(Y_VAR, {"Dvar", 0, lags_level[i][l]});
model.Renew(data[l][0:][i],"var"); 
model.Select(X_VAR, {"var", 1, 1});
model.Select(X_VAR, {"Constant", 0, 0});
//model.Select(X_VAR, {"Trend", 0, 0});															   
if(seasons)
{
model.Select(X_VAR, {"CSeasonal"  , 0, 2});															   
}
model.SetSelSample(start_year, start_quarter + (extra - end), end_year, end_quarter);
model.SetMethod(M_OLS);
model.Estimate();
opt_lag[l][] = meanc(lags_level[][l]); 

tval  = model.GetFreePar() ./ model.GetStdErr(); 
if(seasons)
{
tval_level[i][l] = tval[model.GetFreeParCount() - 5][]; 
}
else
{
tval_level[i][l] = tval[model.GetFreeParCount() - 2][]; 
}
}
}
}
return TRUE;
}